﻿"use strict";

/*
Contains main logic for calculating hashes and returning a valid value
File is ran by a javascript web worker process which runs on a different thread.
*/
if (typeof sha256 !== 'function') {
    importScripts("../vendors/js-sha256.min.js");
}


onmessage = function (msg) {
    //msg.data = object we sent.
    var startTime = new Date();
    var param = getHashResult(msg.data);
    var timeDiff = (new Date().getTime() - startTime.getTime()) / 1000;
    var msgBack = {
        solution: param,
        timeDiff: timeDiff
    };
    postMessage(msgBack);
};

function getHashResult(params) {
    var randomStart = parseInt(Math.random() * 0xFFFFFFFF),
        maxTime = 60 * 1000, //let's stop trying after 1 minute.
        regexToUse = new RegExp(params.hashRegex),
        curTime = new Date();

    //Let's not loop forever.
    while (new Date() - curTime < maxTime) {
        randomStart += 1;
        var trial = params.username + randomStart.toString();
        var hash = sha256(trial); //this func comes from imported script.
        if (hash.match(regexToUse)) {
            return randomStart; 
        }
    }

    return null;
}